/*
 *Keypad sin libreria
 *https://www.youtube.com/watch?v=nMtoCUynG3Y
*/

#include <Mouse.h>
#include "Keyboard.h"    // Esta es una biblioteca "incorporada" sin necesidad de instalar
#include <SoftwareSerial.h>  // Nou
#include <Wire.h>

SoftwareSerial enviar(0,1);  //0 = RX 1 = TX

#define bmano 10
#define lTeclat 12
#define bTeclat 11
#define led13 13

byte pinesFilas[] = {6,7,8,9};    //{5,4,3,2};   
byte pinesColumnas[] = {2,3,4,5}; //{9,8,7,6}; 
char teclasI[4][4] = {
  {'1','2','3','0'}, 
  {'4','5','6','#'}, 
  {'7','8','9','*'}, 
  {'A','B','C','D'}};

char teclasD[4][4] = {
  {'0','1','2','3'}, 
  {'#','4','5','6'}, 
  {'*','7','8','9'}, 
  {'A','B','C','D'}};

char caracters[4][4] ={
  { '<', '>', '@', '='},
  { '{', '}', '#', '&'},
  { '(', ')', '/', '%'},
  { '[', ']', '*', '?'}};
  
int vma = 0;
char vteclas;
char tecla_presionada;

#define PulsadorD A0  // Pulsador derecho
#define PulsadorE A1  // Pulsador izquierdo

const byte filas = 4;     //Numero de filas del teclado
const byte columnas = 4;  //Numero de columnas del teclado


int iniciD = 0;    //Estado incial del pulsdor derecho
int estatACD = 0;  //Estado actual del pulsador derecho
int estatAND = 0;  //Guarda estado anterior del pulsador derecho

int iniciE = 0;    //Estado incial del pulsdor izquierdo
int estatACE = 0;  //Estado actual del pulsador izquierdo
int estatANE = 0;  //Guarda Estado anterior del pulsador izquierdo
int varrosegar = 0; //Manten presionado el boton derecho

int rled = A3;     // Pin PWN 11 para led rojo
int bled = A4;     // Pin PWM 10 para led azul
int vled = A5;     // Pin PWM 9  para led verde

int vdos = 0;
int Velocidad_puntero = 80;

//********** Botón de mano ******
int mpresionado = 0;
int mpresionado1 = 0;

  
void setup()
{
  pinMode(bmano, INPUT);  // Inicializamos el botón de selección de que mano
  pinMode(led13, OUTPUT);
  pinMode(PulsadorD, INPUT);
  pinMode(PulsadorE, INPUT);
    /*----- Se inicializan pines PWM como salida*/  
  pinMode(rled, OUTPUT);
  pinMode(bled, OUTPUT);
  pinMode(vled, OUTPUT);
    /*---- Sel·leccionem teclat com a ratoli o simbols*/
  pinMode(lTeclat, OUTPUT);
  pinMode(bTeclat, INPUT);
  digitalWrite(lTeclat, LOW);
  
  for (int nL = 0; nL <= 3; nL++) {
     pinMode(pinesFilas[nL], OUTPUT);
     digitalWrite(pinesColumnas[nL], HIGH);
  }
 
  for (int nC = 0; nC <= 3; nC++) {
     pinMode(pinesColumnas[nC], INPUT_PULLUP);
  } 
   
  Serial.begin(9600);
  enviar.begin(115200);  // Nou
  Serial.println("Teclado 4x4");
  Serial.println();

  // initialize control over the mouse:
  Mouse.begin();
}

 void loop(){
    
    leds();
    Fma();
    switch (vdos) {
      case 1:       // Led verd
        digitalWrite(rled, LOW);
        digitalWrite(bled, LOW);
        digitalWrite(vled, HIGH);
        Velocidad_puntero = 40;
                  
        //delay(200);
        break;
      case 2:     // Led blau
        digitalWrite(rled, LOW);
        digitalWrite(bled, HIGH);
        digitalWrite(vled, LOW);
        Velocidad_puntero = 20;
        
        //delay(200);
        break;
      case 3:   // Led vermell
        digitalWrite(rled, HIGH);
        digitalWrite(bled, LOW);
        digitalWrite(vled, LOW);
        Velocidad_puntero = 10;
          
      //  delay(200);
        break;  
      case 0:  // Led apagat
          digitalWrite(rled, LOW);
          digitalWrite(bled, LOW);
          digitalWrite(vled, LOW);
          Velocidad_puntero = 80;

         // delay(200);
          break;
     }   

    //Barrido por las filas
    for (int nL = 0; nL <= 3; nL++)
    {
      digitalWrite(pinesFilas[nL], LOW);
      
      //Barrido en columnas buscando un LOW
      for (int nC = 0; nC <= 3; nC++) {
        if (digitalRead(pinesColumnas[nC]) == LOW)
        {
          if(vma == 0){
            vteclas = teclasI[nL][nC];
          }else{
            vteclas = teclasD[nL][nC];
          }  

          if(vma == 3){ //********************** Teclat de caracters
            vteclas = caracters[nL][nC];
            tecla_presionada = vteclas;   //Almaceno en una variable la tecla presionada

           if (tecla_presionada)
            {
               switch (vdos) {
                  case 1:       // Led verd
                    digitalWrite(rled, LOW);
                    digitalWrite(bled, LOW);
                    digitalWrite(vled, HIGH);
                    verd();          
                    delay(200);
                    break;
                  case 2:     // Led blau
                    digitalWrite(rled, LOW);
                    digitalWrite(bled, HIGH);
                    digitalWrite(vled, LOW);
                    blau();
                    delay(200);
                    break;
                  case 3:   // Led vermell
                    digitalWrite(rled, HIGH);
                    digitalWrite(bled, LOW);
                    digitalWrite(vled, LOW);
                    vermell(); 
                    delay(200);
                    break;  
                  case 0:  // Led apagat
                    digitalWrite(rled, LOW);
                    digitalWrite(bled, LOW);
                    digitalWrite(vled, LOW);

                    TeclatP();
                    break;
                 }   
            }

            break;
          }  //** Final de les tecles

          //*** Ratolí
          Serial.print("Tecla: ");
          Serial.print(vteclas);  //(teclas[nL][nC]);
          Serial.print(" ");
          Serial.println(Velocidad_puntero);
         
          if(vteclas == 'A'){  // Inicio de Página
            enviar.write('m');  // Nou
            Mouse.move(0, 0, 1);
          }

          if(vteclas == 'B'){  // Scroll hacia arriba 
            enviar.write('n');  // Nou
            Mouse.move(0, 0, 1);
            delay(80);
          }

          if(vteclas == 'C'){   // Scroll hacia abajo
            enviar.write('M');  // Nou
            Mouse.move(0, 0, -1);
            delay(80);
          }
          
          if(vteclas == 'D'){   // Fin de página
            enviar.write('N');  // Nou
            Mouse.move(0, 0, -1);
          }

          if(vteclas == '#'){       // Botón izquierdo
            enviar.write('o');  // Nou
            Mouse.click(MOUSE_RIGHT);
            delay(250);
          }

          if(vteclas == '*'){      // Botón derecho
            enviar.write('O');  // Nou
            Mouse.click(MOUSE_LEFT);
            delay(250);
          }

          if(vteclas == '0'){      // Doble click
            enviar.write('p');  // Nou
            Mouse.click(MOUSE_LEFT);
            Mouse.click(MOUSE_LEFT);
            delay(250);
          }
          
          if(vteclas == '1'){    // Horizantal arriba izquierda
            enviar.write('P');  // Nou
            Mouse.move(-10, -10, 0);
            delay(Velocidad_puntero);
          }

          if(vteclas == '2'){    // Vertical arriba
            enviar.write('R');  // Nou
            Mouse.move(0, -10, 0);
            delay(Velocidad_puntero);
          }

          if(vteclas == '3'){    // Horizantal arriba derecha
            enviar.write('Q');  // Nou
            Mouse.move(10, -10, 0);
            delay(Velocidad_puntero);
          }

          if(vteclas == '4'){    // Horizontal derecha
            enviar.write('S');  // Nou
            Mouse.move(-10, 0, 0);
            delay(Velocidad_puntero);
          }

          if(vteclas == '5'){    // Manten presionado el botón izquierdo
            if(varrosegar == 0){
              enviar.write('v');  // Nou
              Mouse.press();
              while(digitalRead(pinesColumnas[nC]) == LOW){}  //Evita la repetición de la tecla
              varrosegar = 1; 
            }else{
              enviar.write('V');  // Nou
              Mouse.release();
              while(digitalRead(pinesColumnas[nC]) == LOW){}  //Evita la repetición de la tecla
              varrosegar = 0;
            }
          //  Mouse.move(-10, 0, 0);  // Duptosa
          //  delay(Velocidad_puntero);  //Duptosa
          }          

          if(vteclas == '6'){    // Horizontal izquierda
            enviar.write('t');  // Nou
            Mouse.move(10, 0, 0);
            delay(Velocidad_puntero);
          }         

          if(vteclas == '7'){    // Horizontal abjo izquierda
            enviar.write('r');  // Nou
            Mouse.move(-10, 10, 0);
            delay(Velocidad_puntero);
          }
          

          if(vteclas == '8'){    // Vertical abjo
            enviar.write('s');  // Nou
            Mouse.move(0, 10, 0);
            delay(Velocidad_puntero);
          }

          if(vteclas == '9'){    // Horizontal abjo derecha
            enviar.write('q');  // Nou
            Mouse.move(10, 10, 0);
            delay(Velocidad_puntero);
          }


         
        }
      }
 
      digitalWrite(pinesFilas[nL], HIGH);
    }
}


// *************** Función pulsadores con antirebote **************
void leds(){
/*
  if(digitalRead(PulsadorD) == LOW){
    estatACD = 1;
  }
  if(digitalRead(PulsadorD) == HIGH && estatACD == 1){
    estatACD = 0;
    vdos = 1;
  }

  if(digitalRead(PulsadorE) == LOW){
    estatACE = 1;
  }
  if(digitalRead(PulsadorE) == HIGH && estatACE == 1){
    estatACE = 0;
    vdos = 2;
  }  */
 
    estatACD = digitalRead(PulsadorD); //Leemos el estado del pulsador derecho
    estatACE = digitalRead(PulsadorE); //Leemos el estado del pulsador derecho izquierdo
    vdos = 0;
 
  //Pulsador derecho
    if(estatACD && estatAND == 0){    //Si el pulsador derecho esta pulsado
        iniciD = 1 - iniciD;
        delay(200);
    }
    estatAND = estatACD;
    
    if(iniciD == 1){                  //SI EL PULSADOR ESTA PULSADO
      vdos = 1;
    }

  //Pulsador izquierdo
    if(estatACE && estatANE == 0){    //Si el pulsador izquierdo esta pulsado
        iniciE = 1 - iniciE;
        delay(200);
    }
    estatANE = estatACE;
    
    if(iniciE == 1){                  //SI EL PULSADOR ESTA PULSADO
      vdos = 2;
    }

    if(iniciD == 1 && iniciE == 1){   //SI EL PULSADOR ESTA PULSADO Tecles
      vdos = 3;
    }  
 
}

//******* Función mana *******************
void Fma(){
  if (digitalRead(bmano) == LOW){
    mpresionado = 1;
  }
  if(digitalRead(bmano) == HIGH && mpresionado == 1){
   if(vma==0){
    vma = 1;
   }else{
    vma = 0;
   } 
    digitalWrite(led13, !digitalRead(led13));
    mpresionado = 0;
  }
    // Seleccionem teclat o ratoli
  if (digitalRead(bTeclat) == LOW){
    mpresionado1 = 1;
  }
  if(digitalRead(bTeclat) == HIGH && mpresionado1 == 1){
   if(vma==0){
    vma = 3;
   }else{
    vma = 0;
   } 
    digitalWrite(lTeclat, !digitalRead(lTeclat));
    mpresionado1 = 0;
  }

}
