/*
 * Contavoltes Scalextric
 * Autor Josep Martínez Tejedor
 * Data inici projecte: 6-7-17
 * Data finalització projecte:
 */
// LCD
#include <Wire.h>
#include <LCD.h>
#include <LiquidCrystal_I2C.h>

// Relotge
#include <Time.h>
#include <TimeLib.h>

// Variables del sensor exterior
#define trigpin_e 7
#define echopin_e 8

// Variables del sensor interior
#define trigpin_i 5
#define echopin_i 6


#define I2C_ADDR    0x27
LiquidCrystal_I2C             lcd(I2C_ADDR,2, 1, 0, 4, 5, 6, 7);

#define pulsador 4   // Definm el port que utilitzarem pel pulsador de reset

float duracio_i; 
float duracio_e;  
float distancia_i; 
float distancia_e;  
int volta_e = -1;
int volta_i = -1;
int control_i = 0;  // Son les dues variables que fa un retart abanç de compta un altre volta
int control_e = 0;

// Variables pulsador
int botocero = 0;  //Estat de la sortida d'arranc
int estatAC = 0;  // Estat actual
int estatAN = 0;  // Variable per guardar l'estat anterior del pulsador

// Procediment desl sensors
void distancia()
{
    // Pista interior
  digitalWrite(trigpin_i, LOW);
  delayMicroseconds(2);
  
  digitalWrite(trigpin_i, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigpin_i, LOW);

  duracio_i = pulseIn(echopin_i, HIGH);
  distancia_i = (duracio_i/2)/29.2;

 
  
    lcd.setCursor(5,3);
  //  lcd.print(distancia_i);
  if (control_i == 0)
  {
    if (distancia_i <= 4 && distancia_i >= 0)
      {
        volta_i = volta_i + 1;
        lcd.setCursor(12,2);
        lcd.print(volta_i);
        control_i = 20;
      }
  }
  // Pista exterior
  digitalWrite(trigpin_e, LOW);
  delayMicroseconds(2);
  
  digitalWrite(trigpin_e, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigpin_e, LOW);

  duracio_e = pulseIn(echopin_e, HIGH);
  distancia_e = (duracio_e/2)/29.2;

    lcd.setCursor(12,3);
   // lcd.print(distancia_e);
  if (control_e == 0)
  {
    if (distancia_e <= 4 && distancia_e >= 0)
      {
        volta_e = volta_e + 1;
        lcd.setCursor(12,1);
        lcd.print(volta_e);
        control_e = 20;
      }
  }  
}

// Relotge
void relotge()
{
   // Imprimimos la hora
   lcd.setCursor(4,0);
   lcd.print("Hora: ");
   lcd.print(hour());
   lcd.print(":");
   lcd.print(minute());
/*   lcd.print(":");
   lcd.setCursor(15,0);
   lcd.print("  ");
   lcd.setCursor(15,0);
   lcd.print(second());  */
   
}


void setup()
{
  //Serial.begin (9600);

  pinMode(trigpin_i, OUTPUT);
  pinMode(echopin_i, INPUT);
  pinMode(trigpin_e, OUTPUT);
  pinMode(echopin_e, INPUT);
  pinMode(pulsador, INPUT);
// Establecemos la hora y la fecha 
  setTime(12, 10, 0, 01, 01, 2017);
  
// Inicializar el display con 20 caraceres 4 lineas
  lcd.begin (20,4);    
  lcd.setBacklightPin(3,POSITIVE);
  lcd.setBacklight(HIGH);
  lcd.clear();
  lcd.home ();

// Contavoltes inicial
  lcd.setCursor(0,1);
  lcd.print("Pista Ext.:");
  lcd.setCursor(0,2);
  lcd.print("Pista Int.:");
  lcd.setCursor(12,1);
  lcd.print("0");
  lcd.setCursor(12,2);
  lcd.print("0");
 
}

void loop()
{
  // Comprovar l'estat del botó
  estatAC = digitalRead (pulsador);  // Actualitzem el valor de l variable
     lcd.setCursor(10,1);
      //   lcd.print(estatAC);
  if (estatAC && estatAN == 0)
  {
    botocero = 1 - botocero;
    volta_e = -1;
    volta_i = -1;
    lcd.setCursor(12,1);
    lcd.print("   ");
    lcd.setCursor(12,1);
    // lcd.print(volta_i);
    lcd.print("0");
    lcd.setCursor(12,2);
    lcd.print("   ");
    lcd.setCursor(12,2);
    // lcd.print(volta_e);
    lcd.print("0");
    control_i = 20;
    control_e = 20;
    delay(50);
  }
  estatAN = estatAC;
  relotge();
  distancia();
  
  if (control_i > 0)
  {
    control_i = control_i - 1;
  }
    if (control_e > 0)
  {
    control_e = control_e - 1;
  }

} 
